#!/bin/tcsh

set path = ($path /data/brutus_data0/freeware/afni)
echo $path

mkdir /data/.../FC_reho_SB_DR/SB_rsFC/RSN/Data_subj/

foreach subj (s001 s002)
#foreach subj (002 ... n00)

mkdir /data/.../FC_reho_SB_DR/SB_rsFC/RSN/Data_subj/${subj}/

cd /data/.../FC_reho_SB_DR/SB_rsFC/RSN/Rois/
cp *tlrc* ../Data_subj/${subj}/

foreach roi (a1 a2 f1 f2 p1 p2 d1 d2 d3 e1 e2 f3 f4 p3 p4 m1 m2 m3 s1 s2 s3 v1 v2 v3)

cd /data/.../FC_reho_SB_DR/SB_rsFC/RSN/Data_subj/${subj}/
set rsdir = /data/.../FC_reho_SB_DR/rsfMRIStudy/${subj}/${subj}.results

echo '***************' ${subj} '*************** '

3dmaskave -quiet -mask ${roi}+tlrc $rsdir/errts.${subj}.fanaticor+tlrc. > ${roi}_ts.1D
3dfim+ -polort 2 -mask $rsdir/mask_anat.${subj}+tlrc. -input $rsdir/errts.${subj}.fanaticor+tlrc. -ideal_file ${roi}_ts.1D -out Correlation -bucket Corr_${subj}_${roi}R
3dcalc -a Corr_${subj}_${roi}R+tlrc -expr 'atanh(a)' -prefix Corr_${subj}_${roi}_Z


end
end
